//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

// This is an example program for using the COM interface of SIMCA-Q dll. To build and 
// run this application you must copy SIMCAQ.tlb to the same directory where you have 
// put the source files.
//
// You must also register the SIMCA-Q.dll with regsvr32.

#pragma once

#import "SIMCAQ.tlb"
using namespace SIMCAQLib;

class CSQMCOMSampleDlg : public CDialog
{
   DECLARE_MESSAGE_MAP()

public:
   explicit CSQMCOMSampleDlg(CWnd* pParent = nullptr);	// standard constructor
   ~CSQMCOMSampleDlg() { if (mpFile) fclose(mpFile); }

   enum { IDD = IDD_SQMCOMSAMPLE_DIALOG };

public:
   // Import functions
   void Import(const wchar_t* szTxtFile, const wchar_t* szUspFile);

   // Workset functions
   void CreateWorkset();
   void SaveModel(IWorksetPtr pWorkset);

   // Fit functions
   void FitModel();

protected:
   void DoDataExchange(CDataExchange* pDX) override;	// DDX/DDV support
   BOOL OnInitDialog() override;

private:
   ISIMCAQPtr mpSQ;
   IProjectPtr mpProject;
   FILE* mpFile = nullptr;
   HICON m_hIcon;

public:
   afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
   afx_msg void OnPaint();
   afx_msg HCURSOR OnQueryDragIcon();
   afx_msg void OnBnClickedButton1();
};
